-- Create the measure_matrix table, which specifies all required technology runs by MeasureID.  
--  this table does not check if the technology run is part of an Initialized Prototype run, which
--  can be done by "Create Measure Matrix with IPSpecs" based on this table
DROP TABLE IF EXISTS support."measure_matrix";
CREATE TABLE support.measure_matrix
 AS (SELECT * FROM (
 (SELECT 
 "Measures"."MeasureID",
 "expMeasApplic"."BldgType" as bldgtype,
 "expMeasApplic"."BldgVint" as bldgvint,
 "expMeasApplic"."BldgLoc" as bldgloc,
 "expMeasApplic"."BldgHVAC" as bldghvac,
 "DEER_TStat"."TStatIndex" as tstat,
 COALESCE("Measures"."PreTechID","Measures"."PreMultiTech") as "PreTechID",
 "Measures"."PreSimQual",
 COALESCE("Measures"."StdTechID","Measures"."StdMultiTech") as "StdTechID",
 "Measures"."StdSimQual",
 COALESCE("Measures"."MsrTechID","Measures"."MsrMultiTech") as "MsrTechID",
 "Measures"."MsrSimQual"
 FROM support."Measures" 
 JOIN support."expMeasApplic" on "expMeasApplic"."MeasureID" = "Measures"."MeasureID"  
 JOIN support."DEER_TStat" on "DEER_TStat"."TStatOptions" = "Measures"."TStatOptions"
 WHERE 
  "Measures"."ShowInList" = '1' and
  "Measures"."PreVariTech" IS NULL and
  "Measures"."StdVariTech" IS NULL and
  "Measures"."MsrVariTech" IS NULL
)
UNION
(SELECT 
 "Measures"."MeasureID",
 "expMeasApplic"."BldgType" as bldgtype,
 "expMeasApplic"."BldgVint" as bldgvint,
 "expMeasApplic"."BldgLoc" as bldgloc,
 "expMeasApplic"."BldgHVAC" as bldghvac,
 "DEER_TStat"."TStatIndex" as tstat,
 "expVariTech"."TechID" as "PreTechID",
 "Measures"."PreSimQual",
 COALESCE("Measures"."StdTechID","Measures"."StdMultiTech") as "StdTechID",
 "Measures"."StdSimQual",
 COALESCE("Measures"."MsrTechID","Measures"."MsrMultiTech") as "MsrTechID",
 "Measures"."MsrSimQual"
FROM support."Measures" 
JOIN support."expMeasApplic" on "expMeasApplic"."MeasureID" = "Measures"."MeasureID"  
JOIN support."DEER_TStat" on "DEER_TStat"."TStatOptions" = "Measures"."TStatOptions"
JOIN support."expVariTech" 
  on "expVariTech"."LookupID" = "Measures"."PreVariTech"
 and "expVariTech"."BldgType" = "expMeasApplic"."BldgType"
 and "expVariTech"."BldgVint" = "expMeasApplic"."BldgVint"
 and "expVariTech"."BldgLoc"  = "expMeasApplic"."BldgLoc"
 and "expVariTech"."BldgHVAC" = "expMeasApplic"."BldgHVAC"
WHERE 
  "Measures"."ShowInList" = '1' and
  "Measures"."PreVariTech" IS NOT NULL and
  "Measures"."StdVariTech" IS NULL and
  "Measures"."MsrVariTech" IS NULL
)
UNION
(SELECT 
 "Measures"."MeasureID",
 "expMeasApplic"."BldgType" as bldgtype,
 "expMeasApplic"."BldgVint" as bldgvint,
 "expMeasApplic"."BldgLoc" as bldgloc,
 "expMeasApplic"."BldgHVAC" as bldghvac,
 "DEER_TStat"."TStatIndex" as tstat,
 pre."TechID" as "PreTechID",
 "Measures"."PreSimQual",
 std."TechID" as "StdTechID",
 "Measures"."StdSimQual",
 COALESCE("Measures"."MsrTechID","Measures"."MsrMultiTech") as "MsrTechID",
 "Measures"."MsrSimQual"
FROM support."Measures" 
JOIN support."expMeasApplic" on "expMeasApplic"."MeasureID" = "Measures"."MeasureID"  
JOIN support."DEER_TStat" on "DEER_TStat"."TStatOptions" = "Measures"."TStatOptions"
JOIN support."expVariTech" pre
  on pre."LookupID" = "Measures"."PreVariTech"
 and pre."BldgType" = "expMeasApplic"."BldgType"
 and pre."BldgVint" = "expMeasApplic"."BldgVint"
 and pre."BldgLoc"  = "expMeasApplic"."BldgLoc"
 and pre."BldgHVAC" = "expMeasApplic"."BldgHVAC"
JOIN support."expVariTech" std
  on std."LookupID" = "Measures"."StdVariTech"
 and std."BldgType" = "expMeasApplic"."BldgType"
 and std."BldgVint" = "expMeasApplic"."BldgVint"
 and std."BldgLoc"  = "expMeasApplic"."BldgLoc"
 and std."BldgHVAC" = "expMeasApplic"."BldgHVAC"
WHERE 
  "Measures"."ShowInList" = '1' and
  "Measures"."PreVariTech" IS NOT NULL and
  "Measures"."StdVariTech" IS NOT NULL and
  "Measures"."MsrVariTech" IS NULL
)
UNION
(SELECT 
 "Measures"."MeasureID",
 "expMeasApplic"."BldgType" as bldgtype,
 "expMeasApplic"."BldgVint" as bldgvint,
 "expMeasApplic"."BldgLoc" as bldgloc,
 "expMeasApplic"."BldgHVAC" as bldghvac,
 "DEER_TStat"."TStatIndex" as tstat,
 pre."TechID" as "PreTechID",
 "Measures"."PreSimQual",
 COALESCE("Measures"."StdTechID","Measures"."StdMultiTech") as "StdTechID",
 "Measures"."StdSimQual",
 msr."TechID" as "MsrTechID",
 "Measures"."MsrSimQual"
FROM support."Measures" 
JOIN support."expMeasApplic" on "expMeasApplic"."MeasureID" = "Measures"."MeasureID"  
JOIN support."DEER_TStat" on "DEER_TStat"."TStatOptions" = "Measures"."TStatOptions"
JOIN support."expVariTech" pre
  on pre."LookupID" = "Measures"."PreVariTech"
 and pre."BldgType" = "expMeasApplic"."BldgType"
 and pre."BldgVint" = "expMeasApplic"."BldgVint"
 and pre."BldgLoc"  = "expMeasApplic"."BldgLoc"
 and pre."BldgHVAC" = "expMeasApplic"."BldgHVAC"
JOIN support."expVariTech" msr
  on msr."LookupID" = "Measures"."MsrVariTech"
 and msr."BldgType" = "expMeasApplic"."BldgType"
 and msr."BldgVint" = "expMeasApplic"."BldgVint"
 and msr."BldgLoc"  = "expMeasApplic"."BldgLoc"
 and msr."BldgHVAC" = "expMeasApplic"."BldgHVAC"
WHERE 
  "Measures"."ShowInList" = '1' and
  "Measures"."PreVariTech" IS NOT NULL and
  "Measures"."StdVariTech" IS NULL and
  "Measures"."MsrVariTech" IS NOT NULL
)
) a 
WHERE ((bldgtype in ('SFm','MFm','DMo')) and (bldgvint <> '2014'))
ORDER BY "MeasureID",bldgtype,bldgvint,bldgloc,bldghvac,tstat
)